// ʁE@\ɂȂAʓIȊ֐NXi2006N916Łj
#include "Stdafx.h"
#include "Cmn.h"

using namespace MYAPP;

/* RXgN^iexeƓ̃\[X}l[W[NtH_ǂݍ݁j */
Cmn::Cmn(void)
{
	// RXgN^ł邽߁AO͓ȂBُ펞NULLŏ
	try{
		// t@Cݒǂݍ
		Resource = ResourceManager::CreateFileBasedResourceManager(
			Path::GetFileNameWithoutExtension(Application::ExecutablePath),
			Application::StartupPath,
			nullptr);
	}
	catch(Exception ^e){
		System::Diagnostics::Debug::WriteLine("Cmn::Cmn > OF" + e->ToString());
		Resource = nullptr;
	}
}

/* RXgN^iw肳ꂽ\[X}l[W[w肳ꂽtH_ݒj */
Cmn::Cmn(String ^ i_Resource, String ^i_Dir)
{
	System::Diagnostics::Debug::WriteLine("Cmn::Cmn > " + i_Resource + ", " + i_Dir);
	// RXgN^ł邽߁AO͓ȂBُ펞NULLŏ
	try{
		// t@Cݒǂݍ
		Resource = ResourceManager::CreateFileBasedResourceManager(i_Resource, i_Dir, nullptr);
	}
	catch(Exception ^e){
		System::Diagnostics::Debug::WriteLine("Cmn::Cmn > OF" + e->ToString());
		Resource = nullptr;
	}
}

/* RXgN^inꂽ\[X}l[W[gpj */
Cmn::Cmn(ResourceManager ^i_Resource)
{
	// nꂽ\[X}l[W[̂܂܎gp
	Resource = i_Resource;
}

/* fXgN^ */
Cmn::~Cmn(){
	// ꉞIɉ
	if(Resource != nullptr){
		delete Resource;
	}
}


// v\[X}l[W[̃\bh

/* ʒʒm_CAOi͂ꂽ\j */
void Cmn::InformationDialog(String ^i_Msg)
{
	// nꂽŒʒm_CAO\
	// ResourceNULL̏ꍇANullReferenceException̂܂ܕԂ
	MessageBox::Show(
		i_Msg,
		Resource->GetString("InformationTitle"),
		MessageBoxButtons::OK,
		MessageBoxIcon::Information);
}

/* ʒʒm_CAOi͂ꂽŃ\[X擾AtH[}bgĕ\j */
void Cmn::InformationDialogResource(String ^i_Key, ... array<Object^>^ i_args)
{
	// t@C烊\[XǂݎȂꍇArgumentExceptionB
	//   ȊONullReferenceException̂܂ܕԂ

	// L[lȗĂꍇA擪ɒǉď
	String ^key = static_cast<String^>(i_Key->Clone());
	if(key->StartsWith("InformationMessage_") == false){
		key = "InformationMessage_" + i_Key;
	}
	// .resourcesw肳ꂽbZ[Wǂݍ
	String ^text = Resource->GetString(key);
	if(text == nullptr){
		throw gcnew ArgumentException("Resource \"" + key + "\" Not Exist!", "i_Key");
	}
	// \p֐R[
	InformationDialog(String::Format(text, i_args));
}

/* ʌx_CAOi͂ꂽ\j */
void Cmn::WarningDialog(String ^i_Msg)
{
	// nꂽŌx_CAO\
	// ResourceNULL̏ꍇANullReferenceException̂܂ܕԂ
	MessageBox::Show(
		i_Msg,
		Resource->GetString("WarningTitle"),
		MessageBoxButtons::OK,
		MessageBoxIcon::Warning);
}

/* ʌx_CAOi͂ꂽŃ\[X擾AtH[}bgĕ\j */
void Cmn::WarningDialogResource(String ^i_Key, ... array<Object^>^ i_args)
{
	// t@C烊\[XǂݎȂꍇArgumentExceptionB
	//   ȊONullReferenceException̂܂ܕԂ

	// L[lȗĂꍇA擪ɒǉď
	String ^key = static_cast<String^>(i_Key->Clone());
	if(key->StartsWith("WarningMessage_") == false){
		key = "WarningMessage_" + i_Key;
	}
	// .resourcesw肳ꂽbZ[Wǂݍ
	String ^text = Resource->GetString(key);
	if(text == nullptr){
		throw gcnew ArgumentException("Resource \"" + key + "\" Not Exist!", "i_Key");
	}
	// \p֐R[
	WarningDialog(String::Format(text, i_args));
}

/* ʃG[_CAOi͂ꂽ\j */
void Cmn::ErrorDialog(String ^i_Msg)
{
	// nꂽŃG[_CAO\
	// ResourceNULL̏ꍇANullReferenceException̂܂ܕԂ
	MessageBox::Show(
		i_Msg,
		Resource->GetString("ErrorTitle"),
		MessageBoxButtons::OK,
		MessageBoxIcon::Error);
}

/* ʃG[_CAOi͂ꂽŃ\[X擾AtH[}bgĕ\j */
void Cmn::ErrorDialogResource(String ^i_Key, ... array<Object^>^ i_args)
{
	// t@C烊\[XǂݎȂꍇArgumentExceptionB
	//   ȊONullReferenceException̂܂ܕԂ

	// L[lȗĂꍇA擪ɒǉď
	String ^key = static_cast<String^>(i_Key->Clone());
	if(key->StartsWith("ErrorMessage_") == false){
		key = "ErrorMessage_" + i_Key;
	}
	// .resourcesw肳ꂽbZ[Wǂݍ
	String ^text = Resource->GetString(key);
	if(text == nullptr){
		throw gcnew ArgumentException("Resource \"" + key + "\" Not Exist!", "i_Key");
	}
	// \p֐R[
	ErrorDialog(String::Format(text, i_args));
}


// \[X}l[W[nullptrł삷郁\bh

/* tH_I[v */
bool Cmn::OpenFolder(String ^i_Path, bool i_ShowEnabled)
{
	// O͓ȂBsꍇ͑Sfalse

	System::Diagnostics::Debug::WriteLine("Cmn::OpenFolder > " + i_Path);
	// ̏ꍇ͏O
	if(String::IsNullOrEmpty(i_Path)){
		return false;
	}
	// Ώۃf[^̃tH_J
	if(Directory::Exists(i_Path)){
		try{
			Diagnostics::Process::Start("explorer.exe", "/n," + i_Path);
		}
		catch(Exception ^e){
			if(Resource != nullptr && i_ShowEnabled){
				ErrorDialogResource("ErrorMessage_NotDataOpen", e->Message);
			}
			return false;
		}
	}
	else{
		if(Resource != nullptr && i_ShowEnabled){
			ErrorDialogResource("ErrorMessage_NotDataExist");
		}
		return false;
	}
	return true;
}

/* tH_I[viʕ\tOftHglj */
bool Cmn::OpenFolder(String ^i_Path)
{
	return OpenFolder(i_Path, true);
}

/* t@CI[v */
bool Cmn::OpenFile(String ^i_Path, bool i_ShowEnabled)
{
	// O͓ȂBsꍇ͑Sfalse

	System::Diagnostics::Debug::WriteLine("Cmn::OpenFile > " + i_Path);
	// ̃Z͏O
	if(String::IsNullOrEmpty(i_Path)){
		return false;
	}
	// Ώۃf[^J
	if(File::Exists(i_Path)){
		try{
			Diagnostics::Process::Start(i_Path);
		}
		catch(Exception ^e){
			if(Resource != nullptr && i_ShowEnabled){
				ErrorDialogResource("ErrorMessage_NotDataOpen", e->Message);
			}
			return false;
		}
	}
	else{
		if(Resource != nullptr && i_ShowEnabled){
			ErrorDialogResource("ErrorMessage_NotDataExist");
		}
		return false;
	}
	return true;
}

/* t@CI[viʕ\tOftHglj */
bool Cmn::OpenFile(String ^i_Path)
{
	return OpenFile(i_Path, true);
}

/* T[o[ڑ`FbN */
bool Cmn::Ping(String ^i_Server, bool i_ShowEnabled)
{
	// O͓ȂBsꍇ͑Sfalse

	// T[o[ڑ`FbN
	NetworkInformation::Ping ^ping = gcnew NetworkInformation::Ping();
	try{
		NetworkInformation::PingReply ^reply = ping->Send(i_Server);
		if(reply->Status != NetworkInformation::IPStatus::Success){
			if(Resource != nullptr && i_ShowEnabled){
				ErrorDialogResource("ErrorMessage_MissNetworkAccess", reply->Status.ToString());
			}
			return false;
		}
	}
	catch(Exception ^e){
		if(Resource != nullptr && i_ShowEnabled){
			ErrorDialogResource("ErrorMessage_MissNetworkAccess", e->InnerException->Message);
		}
		return false;
	}
	return true;
}

/* T[o[ڑ`FbNiʕ\tOftHglj */
bool Cmn::Ping(String ^i_Server)
{
	return Ping(i_Server, true);
}

/* DataGridViewCSVt@Cւ̏o */
bool Cmn::SaveDataGridViewCsv(DataGridView ^i_View, String ^i_Path, bool i_ShowEnabled)
{
	// O͓ȂBsꍇ͑Sfalse
	try{
		// DataGridView̕\eCSVt@Cɏo
		StreamWriter ^sw = gcnew StreamWriter(i_Path, false, System::Text::Encoding::GetEncoding("Shift-JIS"));
		try{
			// wb_[o
			String ^header = "";
			for each(DataGridViewColumn ^column in i_View->Columns){
				if(header != ""){
					header += ",";
				}
				header += ("\"" + column->HeaderText + "\"");
			}
			sw->WriteLine(header);
			// {̏o
			for(int y = 0; y < i_View->RowCount; y++){
				// \ĂȂs͏O
				if(i_View->Rows[y]->Visible == false){
					continue;
				}
				// 1sƂɏo
				String ^line = "";
				for(int x = 0; x < i_View->ColumnCount; x++){
					if(x != 0){
						line += ",";
					}
					line += ("\"" + NullCheckAndTrim(i_View[x,y]) + "\"");
				}
				sw->WriteLine(line);
			}
		}
		finally{
			sw->Close();
		}
	}
	catch(Exception ^e){
		if(Resource != nullptr && i_ShowEnabled){
			ErrorDialogResource("ErrorMessage_MissFileSaveView", e->Message);
		}
		return false;
	}
	return true;
}

/* DataGridViewCSVt@Cւ̏óiʕ\tOftHglj */
bool Cmn::SaveDataGridViewCsv(DataGridView ^i_View, String ^i_Path)
{
	return SaveDataGridViewCsv(i_View, i_Path, true);
}


// ÓIo֐

/* StringNULLl`FbNTrim */
String^ Cmn::NullCheckAndTrim(String^ i_Str)
{
	// OȂ
	if(i_Str == nullptr){
		return "";
	}
	return i_Str->Trim();
}

/* DataGridViewCellNULLl`FbNTrim */
String^ Cmn::NullCheckAndTrim(DataGridViewCell^ i_Cell)
{
	// OȂ
	if(i_Cell == nullptr){
		return "";
	}
	else if(i_Cell->Value == nullptr){
		return "";
	}
	return i_Cell->Value->ToString()->Trim();
}

/* zւ̗vfiNULLjǉ */
generic<typename T> int Cmn::AddArray(array<T> ^%io_Array)
{
	// ResizeŗOꍇ́Â܂ܓ
	if(io_Array == nullptr){
		io_Array = gcnew array<T>(1); 
		return 0;
	}
	Array::Resize(io_Array, io_Array->Length + 1);
	return io_Array->Length - 1;
}

/* zւ̗vfi͒ljǉ */
generic<typename T> int Cmn::AddArray(array<T> ^%io_Array, T i_Obj)
{
	// ResizeɗOꍇ́Â܂ܓ
	int index = AddArray(io_Array);
	io_Array[index] = i_Obj;
	return index;
}

/* \tg+o[W̕擾iAZu擾j */
String^ Cmn::GetProductName(void)
{
	// OȂBꍇ͂̂܂ܕԂ

	// AZu琻i擾Ao[W(x.xx`)tĕԂ
	Assembly ^assembly = Assembly::GetExecutingAssembly();
	AssemblyProductAttribute ^product = 
		static_cast<AssemblyProductAttribute^>(Attribute::GetCustomAttribute(
			assembly,
			AssemblyProductAttribute::typeid));
	Version ^ver = assembly->GetName()->Version;
	// ߂lԂArhԍErW͖
	return (product->Product + " Ver" + ver->Major + "." + String::Format("{0:D2}",ver->Minor));
}

/* 񒆂̃t@CɎgpłȂu */
String^ Cmn::ReplaceInvalidFileNameChars(String ^i_Str)
{
	// nꂽɃt@CɎgȂ܂܂ĂꍇA_ ɒu
	String ^result = i_Str;
	array<wchar_t> ^unuseChars = Path::GetInvalidFileNameChars();
	for each(wchar_t c in unuseChars){
		result = result->Replace(c, '_');
	}
	return result;
}

/* IuWFNgXMLւ̃VACY */
bool Cmn::XmlSerialize(Object ^i_Obj, String ^i_FileName)
{
	// O͓ȂBsꍇ͑Sfalse

	// ݒVACY
	System::Diagnostics::Debug::WriteLine("Cmn::Serialize > " + i_FileName + "ɃVACY");

	XmlSerializer ^serializer = gcnew XmlSerializer(i_Obj->GetType());
	try{
		Stream^ writer = gcnew FileStream(i_FileName, FileMode::Create);
		try{
			serializer->Serialize(writer, i_Obj);
		}
		finally{
			writer->Close();
		}
	}
	catch(Exception ^e){
		System::Diagnostics::Debug::WriteLine("Cmn::Serialize > OF" + e->ToString());
		return false;
	}
	return true;
}

/* IuWFNgXML̃fVACY */
bool Cmn::XmlDeserialize(Object ^%o_Obj, Type ^i_Type, String ^i_FileName)
{
	// O͓ȂBsꍇ͑Sfalse

	// ݒfVACY
	System::Diagnostics::Debug::WriteLine("Cmn::Deserialize > " + i_FileName + "fVACY");

	// o͒l
	o_Obj = nullptr;
	// gcnewŃOɗOo邪AMSDNɂΖĂ炵EEE
	XmlSerializer ^serializer = gcnew XmlSerializer(i_Type);
	try{
		Stream ^reader = gcnew FileStream(i_FileName, FileMode::Open, FileAccess::Read);
		try{
			o_Obj = serializer->Deserialize(reader);
			// قƂObjecť^ɃLXgđ̂A
			//   @sȂ߁A͌Ăяoōs
		}
		finally{
			reader->Close();
		}
	}
	catch(Exception ^e){
		System::Diagnostics::Debug::WriteLine("Cmn::Deserialize > OF" + e->ToString());
		return false;
	}
	return true;
}

/* Ώۂ̕񂪁Anꂽ̃CfbNXԖڂɑ݂邩`FbN */
bool Cmn::ChkTextInnerWith(String ^i_Text, int i_Index, String ^i_ChkStr)
{
	// i_Text, i_ChkStrNULL̏ꍇ͂̂܂NullReferenceExceptionB
	//   i_Indexi_Text͈̔͊ÔƂArgumentExceptionԂ

	// ͒l`FbN
	if((i_Index < 0) || (i_Index >= i_Text->Length)){
		throw gcnew ArgumentException("IndexOutOfRange! : " + i_Index, "i_Index");
	}
	if(i_ChkStr == ""){
		return true;
	}
	if(i_Text == ""){
		return false;
	}
	// ̈v`FbN
	// 1ڂif͑xIɂ̕ȂƎvĂĂBvȂEEE
	if(i_Text[i_Index] == i_ChkStr[0]){
		if((i_Index + i_ChkStr->Length) <= i_Text->Length){
			if(i_Text->Substring(i_Index, i_ChkStr->Length) == i_ChkStr){
				return true;
			}
		}
	}
	return false;
}

/* R{{bNXmFA݂̒lꗗɖΓo^ */
bool Cmn::AddComboBoxNewItem(ComboBox ^%io_Box, String ^i_FirstStr)
{
	// io_BoxNULL̏ꍇȂǂ́ANullReferenceException̂܂ܕԂ

//	System::Diagnostics::Debug::WriteLine("Cmn::AddComboBoxNewItem > " + io_Box->Text + ", " + i_FirstStr);
	if(io_Box->Text != ""){
		// ݂̒li_FirstStrn܂ĂȂꍇ́Ai_FirstStrtď
		String ^text = io_Box->Text;
		if(i_FirstStr != nullptr && i_FirstStr != ""){
			if(text->StartsWith(i_FirstStr) == false){
				text = i_FirstStr + io_Box->Text;
			}
		}
		// ݂̒lɈv̂邩mF
		if(io_Box->Items->Contains(text) == false){
			// ݂ȂꍇA݂̒lꗗɒǉ
			io_Box->Items->Add(text);
			return true;
		}
	}
	return false;
}

/* R{{bNXmFA݂̒lꗗɖΓo^ */
bool Cmn::AddComboBoxNewItem(ComboBox ^%io_Box)
{
	// ǉ񖳂ŁA̊֐R[
	return AddComboBoxNewItem(io_Box, "");
}

/* R{{bNXmFAIĂl폜 */
bool Cmn::RemoveComboBoxItem(ComboBox ^%io_Box)
{
	// io_BoxNULL̏ꍇȂǂ́ANullReferenceException̂܂ܕԂ

//	System::Diagnostics::Debug::WriteLine("Cmn::RemoveComboBoxItem > " + io_Box->SelectedIndex.ToString());
	// IĂACe폜
	if(io_Box->SelectedIndex != -1){
		io_Box->Items->Remove(io_Box->SelectedItem);
		io_Box->SelectedText = "";
	}
	else{
		// IĂȂꍇA͂ꂽ񂾂͏Ă
		io_Box->Text = "";
		return false;
	}
	return true;
}
